unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, AppEvnts;

type
  TForm2 = class(TForm)
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    btnKOLOR: TBitBtn;
    Image: TImage;
    Label1: TLabel;
    ApplicationEvents1: TApplicationEvents;
    procedure btnKOLORMouseLeave(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure Label1MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure ImageMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure btnKOLORMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure ApplicationEvents1Idle(Sender: TObject; var Done: Boolean);
    procedure FormShow(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);

  private
    tempPict1  : TBitmap;
    tempPict2  : TBitmap;
    tempGlyph1 : TBitmap;
    tempGlyph2 : TBitmap;

    wObszarzeObrazka   : Boolean;
    wObszarzePrzycisku : Boolean;
    wObszarzeEtykiety  : Boolean;

	 logo1  : String;
    logo2  : String;
    glyph1 : String;
    glyph2 : String;

  public
	procedure Spr(); 
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}

procedure TForm2.ApplicationEvents1Idle(Sender: TObject; var Done: Boolean);
begin
	Spr();
end;

procedure TForm2.BitBtn1Click(Sender: TObject);
begin
	Close();
end;

procedure TForm2.FormPaint(Sender: TObject);
var
	wys  : Integer;
	szer : Integer;
	R    : TRect;
   x    : Integer;
   y    : Integer;

begin
	wys  := Label1.ClientHeight;
	szer := Label1.ClientWidth;
	R    := Label1.ClientRect;

	// przekrelona na czerwono
   // Etykieta (na ukos z gry w d po przektnej)
   Label1.Canvas.Brush.Color := clRed;

   x := Label1.ClientRect.Left;
   y := Label1.ClientRect.Top;

   Label1.Canvas.MoveTo(x, y);
   Label1.Canvas.LineTo(x+szer, y+wys);
end;

procedure TForm2.Spr();
var
	wys  : Integer;
	szer : Integer;
	R    : TRect;
   x    : Integer;
   y    : Integer;

begin
	wys  := Label1.ClientHeight;
	szer := Label1.ClientWidth;
	R    := Label1.ClientRect;

	// przekrelona na czerwono
   // Etykieta (na ukos z gry w d po przektnej)
   Label1.Canvas.Brush.Color := clRed;

   x := Label1.ClientRect.Left;
   y := Label1.ClientRect.Top;

   Label1.Canvas.MoveTo(x, y);
   Label1.Canvas.LineTo(x+szer, y+wys);
end;


procedure TForm2.btnKOLORMouseLeave(Sender: TObject);
begin
   btnKOLOR.Font.Color := clBlack;
end;

procedure TForm2.btnKOLORMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
   btnKOLOR.Font.Color := clRed;
end;

procedure TForm2.Label1MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
	//
end;

procedure TForm2.FormShow(Sender: TObject);
begin
	wObszarzeObrazka   := false;
   wObszarzePrzycisku := false;
   wObszarzeEtykiety  := false;

	logo1  := ExtractFilePath(Application.ExeName) + 'logo1.bmp';
   logo2  := ExtractFilePath(Application.ExeName) + 'logo2.bmp';
   glyph1 := ExtractFilePath(Application.ExeName) + 'glyph1.bmp';
   glyph2 := ExtractFilePath(Application.ExeName) + 'glyph2.bmp';

	Image.Picture.Bitmap.LoadFromFile(logo1);   
end;

procedure TForm2.ImageMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
	// po to eby zaadowa obrazek tylko jeden raz
   if not wObszarzeObrazka then
	begin
      Image.Picture.Bitmap.LoadFromFile(logo2);
      wObszarzeObrazka := true;
   end;
end;

procedure TForm2.FormMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
	if wObszarzeObrazka then
   begin
   	Image.Picture.Bitmap.LoadFromFile(logo1);
      wObszarzeObrazka := false;
   end;
end;

end.

